﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace Darkminer_v6
{
	// Token: 0x02000009 RID: 9
	[DesignerGenerated]
	public partial class Form1 : Form
	{
		// Token: 0x0600003E RID: 62 RVA: 0x00003DA4 File Offset: 0x00001FA4
		public Form1()
		{
			base.Load += this.Form1_Load;
			this.cancellationTokenSource = new CancellationTokenSource();
			this.random = new Random();
			this.tries = 0;
			this.isMining = false;
			this.foundCount = 0;
			this.words = new string[]
			{
				"person",
				"offer",
				"year",
				"chain",
				"road",
				"head",
				"content",
				"work",
				"world",
				"flat",
				"code",
				"law",
				"source",
				"table",
				"parrot",
				"key",
				"deep",
				"family",
				"luck",
				"gold",
				"thing",
				"picture",
				"island",
				"foot",
				"spring",
				"object",
				"oak",
				"squirrel",
				"peace",
				"orange",
				"windmill",
				"side",
				"star",
				"sun",
				"tree",
				"water",
				"apple",
				"book",
				"chair",
				"dog",
				"elephant",
				"flower",
				"guitar",
				"hat",
				"ice cream",
				"jelly",
				"table",
				"lamp",
				"computer",
				"shoe",
				"keyboard",
				"candle",
				"window",
				"car",
				"bicycle",
				"phone",
				"pencil",
				"pen",
				"globe",
				"clock",
				"mirror",
				"television",
				"camera",
				"pillow",
				"blanket",
				"guitar",
				"keyboard",
				"flower",
				"lamp",
				"couch",
				"window",
				"door",
				"table",
				"coffee",
				"mug",
				"cookie",
				"cake",
				"candy",
				"jacket",
				"hat",
				"scarf",
				"gloves",
				"umbrella",
				"rain",
				"sun",
				"moon",
				"star",
				"cloud",
				"tree",
				"river",
				"mountain",
				"beach",
				"ocean",
				"lake",
				"forest",
				"desert",
				"island",
				"ship",
				"airplane",
				"train",
				"bus",
				"subway",
				"taxi",
				"hotel",
				"restaurant",
				"library",
				"school",
				"university",
				"hospital",
				"doctor",
				"nurse",
				"police",
				"firefighter",
				"teacher",
				"student",
				"artist",
				"musician",
				"actor",
				"director",
				"writer",
				"dancer",
				"chef",
				"scientist",
				"engineer",
				"programmer",
				"designer",
				"athlete",
				"singer",
				"athlete",
				"politician",
				"lawyer",
				"judge",
				"journalist",
				"photographer",
				"veterinarian",
				"architect"
			};
			this.textBuilder = new StringBuilder();
			this.InitializeComponent();
		}

		// Token: 0x17000019 RID: 25
		// (get) Token: 0x06000041 RID: 65 RVA: 0x00002571 File Offset: 0x00000771
		// (set) Token: 0x06000042 RID: 66 RVA: 0x00004ADC File Offset: 0x00002CDC
		internal virtual Button StartButton
		{
			[CompilerGenerated]
			get
			{
				return this._StartButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StartButton_Click);
				Button startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click -= value2;
				}
				this._StartButton = value;
				startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click += value2;
				}
			}
		}

		// Token: 0x1700001A RID: 26
		// (get) Token: 0x06000043 RID: 67 RVA: 0x0000257B File Offset: 0x0000077B
		// (set) Token: 0x06000044 RID: 68 RVA: 0x00004B20 File Offset: 0x00002D20
		internal virtual Button StopButton
		{
			[CompilerGenerated]
			get
			{
				return this._StopButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StopButton_Click);
				Button stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click -= value2;
				}
				this._StopButton = value;
				stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click += value2;
				}
			}
		}

		// Token: 0x1700001B RID: 27
		// (get) Token: 0x06000045 RID: 69 RVA: 0x00002585 File Offset: 0x00000785
		// (set) Token: 0x06000046 RID: 70 RVA: 0x0000258F File Offset: 0x0000078F
		internal virtual RichTextBox ResultRichTextBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001C RID: 28
		// (get) Token: 0x06000047 RID: 71 RVA: 0x00002598 File Offset: 0x00000798
		// (set) Token: 0x06000048 RID: 72 RVA: 0x000025A2 File Offset: 0x000007A2
		internal virtual CheckBox EthCheckBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001D RID: 29
		// (get) Token: 0x06000049 RID: 73 RVA: 0x000025AB File Offset: 0x000007AB
		// (set) Token: 0x0600004A RID: 74 RVA: 0x000025B5 File Offset: 0x000007B5
		internal virtual Label RecordCountLabel { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001E RID: 30
		// (get) Token: 0x0600004B RID: 75 RVA: 0x000025BE File Offset: 0x000007BE
		// (set) Token: 0x0600004C RID: 76 RVA: 0x000025C8 File Offset: 0x000007C8
		internal virtual RichTextBox Izpis { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x1700001F RID: 31
		// (get) Token: 0x0600004D RID: 77 RVA: 0x000025D1 File Offset: 0x000007D1
		// (set) Token: 0x0600004E RID: 78 RVA: 0x000025DB File Offset: 0x000007DB
		internal virtual Label Found { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000020 RID: 32
		// (get) Token: 0x0600004F RID: 79 RVA: 0x000025E4 File Offset: 0x000007E4
		// (set) Token: 0x06000050 RID: 80 RVA: 0x000025EE File Offset: 0x000007EE
		internal virtual PictureBox PictureBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x17000021 RID: 33
		// (get) Token: 0x06000051 RID: 81 RVA: 0x000025F7 File Offset: 0x000007F7
		// (set) Token: 0x06000052 RID: 82 RVA: 0x00004B64 File Offset: 0x00002D64
		internal virtual Button Button1
		{
			[CompilerGenerated]
			get
			{
				return this._Button1;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.Button1_Click);
				Button button = this._Button1;
				if (button != null)
				{
					button.Click -= value2;
				}
				this._Button1 = value;
				button = this._Button1;
				if (button != null)
				{
					button.Click += value2;
				}
			}
		}

		// Token: 0x17000022 RID: 34
		// (get) Token: 0x06000053 RID: 83 RVA: 0x00002601 File Offset: 0x00000801
		// (set) Token: 0x06000054 RID: 84 RVA: 0x0000260B File Offset: 0x0000080B
		private virtual System.Windows.Forms.Timer timer { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x06000055 RID: 85 RVA: 0x00004BA8 File Offset: 0x00002DA8
		private void Form1_Load(object sender, EventArgs e)
		{
			this.ResultRichTextBox.ReadOnly = true;
			this.ResultRichTextBox.BackColor = Color.Black;
			this.ResultRichTextBox.Font = new Font(SystemFonts.DefaultFont.FontFamily, 12f);
			this.ResultRichTextBox.WordWrap = false;
			this.timer = new System.Windows.Forms.Timer();
			this.timer.Tick += this.Timer_Tick;
			this.timer.Interval = 1980000;
			this.timer.Start();
			System.Windows.Forms.Timer timer = new System.Windows.Forms.Timer();
			timer.Tick += this.InternetCheckTimer_Tick;
			timer.Interval = 5000;
			timer.Start();
		}

		// Token: 0x06000056 RID: 86 RVA: 0x00004C70 File Offset: 0x00002E70
		private void InternetCheckTimer_Tick(object sender, EventArgs e)
		{
			bool flag = this.CheckForInternetConnection();
			bool flag2 = !flag;
			if (flag2)
			{
				this.StopMining();
			}
		}

		// Token: 0x06000057 RID: 87 RVA: 0x00004C98 File Offset: 0x00002E98
		private void StopMining()
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.timer.Stop();
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x06000058 RID: 88 RVA: 0x00004D10 File Offset: 0x00002F10
		private void AppendTextWithScroll(string text, Color color, bool isBold, float fontSize)
		{
			bool invokeRequired = this.ResultRichTextBox.InvokeRequired;
			if (invokeRequired)
			{
				this.ResultRichTextBox.Invoke(delegate()
				{
					this.AppendTextWithScroll(text, color, isBold, fontSize);
				});
			}
			else
			{
				this.ResultRichTextBox.SelectionColor = color;
				bool $VB$Local_isBold = isBold;
				if ($VB$Local_isBold)
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Bold);
				}
				else
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Regular);
				}
				this.textBuilder.Append(text + " ");
				bool flag = text.EndsWith("\r\n");
				if (flag)
				{
					this.ResultRichTextBox.AppendText(this.textBuilder.ToString().TrimEnd() + Environment.NewLine);
					this.ResultRichTextBox.ScrollToCaret();
					this.textBuilder.Clear();
				}
				this.UpdateRecordCountLabel();
			}
		}

		// Token: 0x06000059 RID: 89 RVA: 0x00004E60 File Offset: 0x00003060
		private bool CheckForInternetConnection()
		{
			bool result;
			try
			{
				WebRequest webRequest = WebRequest.Create("http://www.google.com");
				WebResponse response = webRequest.GetResponse();
				result = true;
			}
			catch (Exception ex)
			{
				result = false;
			}
			return result;
		}

		// Token: 0x0600005A RID: 90 RVA: 0x00002614 File Offset: 0x00000814
		private void UpdateRecordCountLabel()
		{
			this.RecordCountLabel.Text = string.Format("Checked: {0}", this.ResultRichTextBox.Lines.Length);
		}

		// Token: 0x0600005B RID: 91 RVA: 0x00004EA8 File Offset: 0x000030A8
		private async void StartButton_Click(object sender, EventArgs e)
		{
			Form1._Closure$__57-0 CS$<>8__locals1 = new Form1._Closure$__57-0(CS$<>8__locals1);
			CS$<>8__locals1.$VB$Me = this;
			bool flag = this.isMining;
			if (!flag)
			{
				CS$<>8__locals1.$VB$Local_selectedCrypto = "";
				bool @checked = this.EthCheckBox.Checked;
				if (@checked)
				{
					CS$<>8__locals1.$VB$Local_selectedCrypto = "BTC";
					bool validCrypto = false;
					bool flag2 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0 || Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
					if (flag2)
					{
						Form1._Closure$__57-1 CS$<>8__locals2 = new Form1._Closure$__57-1(CS$<>8__locals2);
						CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2 = CS$<>8__locals1;
						validCrypto = true;
						this.isMining = true;
						this.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.Green, true, 16f);
						CS$<>8__locals2.$VB$Local_trueInterval = 1000;
						await Task.Run(delegate()
						{
							int num = 0;
							while (!CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.cancellationTokenSource.Token.IsCancellationRequested)
							{
								bool flag3 = CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.tries > CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.random.Next(1500, 1000000000);
								if (flag3)
								{
									string text = Form1.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									bool flag4 = Operators.CompareString(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Local_selectedCrypto, "ETH", false) == 0;
									if (flag4)
									{
										double num2 = Math.Round(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.random.NextDouble() * 2.9 + 0.1, 4);
									}
									else
									{
										bool flag5 = Operators.CompareString(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Local_selectedCrypto, "BTC", false) == 0;
										if (flag5)
										{
											double num2 = Math.Round(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.random.NextDouble() * 0.99 + 0.01, 4);
										}
									}
									List<string> list = new List<string>();
									int num3 = 0;
									checked
									{
										do
										{
											bool flag6 = num3 < CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.words.Length;
											if (flag6)
											{
												list.Add(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.words[CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.random.Next(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.words.Length)]);
											}
											num3++;
										}
										while (num3 <= 11);
										string text2 = string.Format("Wallet check:     {0}", string.Join(" ", list));
										text2 += "\r\n";
										Thread.Sleep(80);
										CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.AppendTextWithScroll(text2, Color.White, false, 8f);
										Thread.Sleep(80);
										CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.tries = 0;
										CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.White, false, 8f);
										Thread.Sleep(80);
									}
								}
								else
								{
									string text3 = Form1.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									List<string> list2 = new List<string>();
									int num4 = 0;
									bool flag7;
									checked
									{
										do
										{
											list2.Add(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.words[CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.random.Next(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.words.Length)]);
											num4++;
										}
										while (num4 <= 11);
										string text4 = string.Format("Wallet check:   {0}", string.Join(" ", list2));
										text4 += "\r\n";
										Thread.Sleep(80);
										CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.AppendTextWithScroll(text4, Color.White, false, 10f);
										Form1 $VB$Me = CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me;
										ref int ptr = ref $VB$Me.tries;
										$VB$Me.tries = ptr + 1;
										num++;
										flag7 = (num >= CS$<>8__locals2.$VB$Local_trueInterval);
									}
									if (flag7)
									{
										string text5 = Form1.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
										bool flag8 = Operators.CompareString(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Local_selectedCrypto, "ETH", false) == 0;
										if (flag8)
										{
											double num5 = Math.Round(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.random.NextDouble() * 2.9 + 0.1, 4);
										}
										else
										{
											bool flag9 = Operators.CompareString(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Local_selectedCrypto, "BTC", false) == 0;
											if (flag9)
											{
												double num5 = Math.Round(CS$<>8__locals2.$VB$NonLocal_$VB$Closure_2.$VB$Me.random.NextDouble() * 0.99 + 0.01, 4);
											}
										}
										bool flag10 = (long)CS$<>8__locals2.$VB$Local_trueInterval == 1000000000000L;
										if (flag10)
										{
											CS$<>8__locals2.$VB$Local_trueInterval = 1500000000;
										}
									}
								}
							}
						});
						this.timer.Start();
						this.isMining = true;
					}
					if (!validCrypto)
					{
						MessageBox.Show("Please choose a valid currency (ETH or BTC).", "Invalid Currency", MessageBoxButtons.OK, MessageBoxIcon.Hand);
					}
				}
				else
				{
					MessageBox.Show("Please select a valid currency.", "Invalid Currency", MessageBoxButtons.OK, MessageBoxIcon.Hand);
				}
			}
		}

		// Token: 0x0600005C RID: 92 RVA: 0x00004C98 File Offset: 0x00002E98
		private void StopButton_Click(object sender, EventArgs e)
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.timer.Stop();
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x0600005D RID: 93 RVA: 0x00004EF0 File Offset: 0x000030F0
		private static string id_gen(int size = 38, string chars = "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789")
		{
			Random random = new Random();
			return new string((from s in Enumerable.Repeat<string>(chars, size)
			select s[random.Next(s.Length)]).ToArray<char>());
		}

		// Token: 0x0600005E RID: 94 RVA: 0x00004F38 File Offset: 0x00003138
		private void Timer_Tick(object sender, EventArgs e)
		{
			bool flag = this.isMining && !this.cancellationTokenSource.Token.IsCancellationRequested;
			if (flag)
			{
				int num = this.random.Next(0, 30);
				string[] array = new string[]
				{
					"btc 0.00361 = 157.18$ | LOCKED",
					"btc 0.00231 = 99.22$ | LOCKED",
					"btc 0.00093 = 40.01$ | LOCKED",
					"btc 0.00265 = 111.81$ | LOCKED",
					"btc 0.00176 = 73.60$ | LOCKED",
					"btc 0.00465 = 199.78$ | LOCKED",
					"btc 0.00194 = 84.21$ | LOCKED",
					"btc 0.00185 = 79.83$ | LOCKED",
					"btc 0.00316 = 133.94$ | LOCKED",
					"btc 0.00404 = 173.76$ | LOCKED",
					"btc 0.00281 = 120.69$ | LOCKED",
					"btc 0.00494 = 213.49$ | LOCKED",
					"btc 0.00049 = 21.96$ | LOCKED",
					"btc 0.00115 = 46.71$ | LOCKED",
					"btc 0.00343 = 149.29$ | LOCKED",
					"btc 0.00422 = 183.11$ | LOCKED",
					"btc 0.00561 = 244.92$ | LOCKED",
					"btc 0.00259 = 109.53$ | LOCKED",
					"btc 0.00478 = 202.37$ | LOCKED",
					"btc 0.00337 = 144.09$ | LOCKED",
					"btc 0.00336 = 142.63$ | LOCKED",
					"btc 0.00385 = 163.80$ | LOCKED",
					"btc 0.00224 = 96.49$ | LOCKED",
					"btc 0.00386 = 164.99$ | LOCKED",
					"btc 0.00235 = 100.90$ | LOCKED",
					"btc 0.00104 = 45.07$ | LOCKED",
					"btc 0.00278 = 117.15$ | LOCKED",
					"btc 0.00307 = 130.56$ | LOCKED",
					"btc 0.00445 = 190.76$ | LOCKED",
					"btc 0.00542 = 233.60$ | LOCKED",
					"btc 0.00591 = 254.52$ | LOCKED"
				};
				string text = array[num] + Environment.NewLine;
				this.Izpis.AppendText(text);
				ref int ptr = ref this.foundCount;
				this.foundCount = checked(ptr + 1);
				this.Found.Text = string.Format("Found: {0}", this.foundCount);
				this.timer.Interval = 288000000;
				this.SaveToDesktopFile("results.txt", text);
			}
		}

		// Token: 0x0600005F RID: 95 RVA: 0x00005104 File Offset: 0x00003304
		private void SaveToDesktopFile(string fileName, string content)
		{
			string folderPath = Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory);
			string path = Path.Combine(folderPath, fileName);
			using (StreamWriter streamWriter = new StreamWriter(path, true))
			{
				streamWriter.Write(content);
			}
		}

		// Token: 0x06000060 RID: 96 RVA: 0x00005154 File Offset: 0x00003354
		private void Button1_Click(object sender, EventArgs e)
		{
			Form3 form = new Form3();
			form.Show();
		}

		// Token: 0x04000024 RID: 36
		private CancellationTokenSource cancellationTokenSource;

		// Token: 0x04000025 RID: 37
		private Random random;

		// Token: 0x04000026 RID: 38
		private int tries;

		// Token: 0x04000027 RID: 39
		private bool isMining;

		// Token: 0x04000029 RID: 41
		private int foundCount;

		// Token: 0x0400002A RID: 42
		private string[] words;

		// Token: 0x0400002B RID: 43
		private StringBuilder textBuilder;
	}
}
